%------------------------------------------------------------------------------
% File     : SYO532^1 : TPTP v7.4.0. Released v5.2.0.
% Domain   : Syntactic
% Problem  : Binary choice on individuals 3
% Version  : Especial.
% English  : Epsa and (epsb Epsa) work together to give an a and b such that R
%            a b holds, if such an a and b exist for a binary relation R on $i.
%            A choice operator on i can be used to define a choice operator on
%            i*i (Curried). In this version, the second half of the solution is
%            given.

% Refs     : [Bac10] Backes (2010), Tableaux for Higher-Order Logic with If
%          : [Bro11] Brown E. (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE9 [Bro11]

% Status   : Theorem
% Rating   : 0.86 v7.4.0, 0.89 v7.2.0, 0.88 v7.0.0, 0.86 v6.4.0, 0.83 v6.3.0, 0.80 v6.2.0, 0.71 v5.5.0, 0.83 v5.4.0, 0.80 v5.2.0
% Syntax   : Number of formulae    :    5 (   0 unit;   2 type;   1 defn)
%            Number of atoms       :   21 (   1 equality;  16 variable)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   16 (   0   ~;   0   |;   0   &;  14   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   20 (  20   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   2   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   2   !;   4   ?;   3   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(eps,type,(
    eps: ( $i > $o ) > $i )).

thf(choiceax,axiom,(
    ! [P: $i > $o] :
      ( ? [X: $i] :
          ( P @ X )
     => ( P @ ( eps @ P ) ) ) )).

thf(epsb,type,(
    epsb: ( ( $i > $i > $o ) > $i ) > ( $i > $i > $o ) > $i )).

thf(epsbd,definition,
    ( epsb
    = ( ^ [Epsa: ( $i > $i > $o ) > $i,R: $i > $i > $o] :
          ( eps
          @ ^ [Y: $i] :
              ( R @ ( Epsa @ R ) @ Y ) ) ) )).

thf(conj,conjecture,(
    ? [Epsa: ( $i > $i > $o ) > $i] :
    ! [R: $i > $i > $o] :
      ( ? [X: $i,Y: $i] :
          ( R @ X @ Y )
     => ( R @ ( Epsa @ R ) @ ( epsb @ Epsa @ R ) ) ) )).

%------------------------------------------------------------------------------
